#ifndef _TIMER_H_
#define _TIMER_H_

#define TIMER_TIMEOUTS     8    

/*** Prototypen fuer Functionn ***/

// <TITLE Timer_Init>
// Description:
// Initializes the Timer.
// Parameter:
// none
// Result:
// none
void  Timer_Init(void) ;

// <TITLE Timer_Set()>
// Description:
// Sets a downcounting Timer to a given value.
// Parameter:
// nr: number of Timer 0..7
// ms: Downcount-Time in Milliseconds.
// Result:
// none
void  Timer_Set(u8_t nr, u16_t ms) ;

// <TITLE Timer()>
// Description:
// Reads back a Timer. The Timer is decremented every Millisecond. If the function returns 0 the Timer is stopped.
// Parameter:
// nr: number of Timer 0..7
// Result:
// Remaining milliseconds.
// If nr is >7 (invalid Timer), the function returns 0xffff.
u16_t Timer(u8_t nr) ;

// <TITLE Timer_SystemReset>
// Description:
// Resets a global Timer that starts counting Milliseconds at Power on.
// Parameter:
// none
// Result:
// none
void Timer_SystemReset(void);

// <TITLE Timer_SystemTime>
// Description:
// Reads back a global Timer that starts counting Milliseconds at Power on.
// Parameter:
// none
// Result:
// Number of Milliseconds since Power on.

unsigned long Timer_SystemTime(void) ;

extern unsigned long int GlobalMillis;

__interrupt void ReloadTimer1(void);

#endif

