#ifndef _mCAN_H_
#define _mCAN_H_

#include "compiler.h"
#ifndef CAN_ERR_OK	// bereits incan.h definiert!
/**** Fehlerzustaende ****/
#define CAN_ERR_OK        0x00
#define CAN_ERR_XMTFULL   0x01  /* Sendepuffer im Controller ist voll */
#define CAN_ERR_OVERRUN   0x02  /* CAN-Controller wurde zu spaet gelesen */
#define CAN_ERR_BUSLIGHT  0x04  /* Busfehler: ein Errorcounter erreichte Limit */
#define CAN_ERR_BUSHEAVY  0x08  /* Busfehler: ein Errorcounter erreichte Limit */
#define CAN_ERR_BUSOFF    0x10  /* Busfehler: CAN_Controller ging 'Bus-Off' */
#define CAN_ERR_QRCVEMPTY 0x20  /* RcvQueue ist leergelesen */
#define CAN_ERR_QOVERRUN  0x40  /* RcvQueue wurde zu spaet gelesen */
#define CAN_ERR_QXMTFULL  0x80  /* Sendequeue ist voll */

#define CAN_ERR_ANYBUSERR (CAN_ERR_BUSLIGHT | CAN_ERR_BUSHEAVY | CAN_ERR_BUSOFF)

#define CAN_ErrorDummyID  0xFFFF /* ID fuer Messages, die keine empfangenen
									Message, sondern Fehler transportieren */

#define CAN_BAUD_1M     0x2b00u
#define CAN_BAUD_500K   0x2b01u
#define CAN_BAUD_250K   0x2b03u
#define CAN_BAUD_125K   0x3A07u  
#define CAN_BAUD_100K   0x4D07u  
#define CAN_BAUD_50K    0x4D0fu  
#define CAN_BAUD_20K    0x4D27u 
#define CAN_BAUD_83K3	0x1417u
#define CAN_BAUD_47K6	0x1429u
#define CAN_BAUD_95K2	0x1414u
#define CAN_BAUD_33K3	0x581Du

#endif
                                   
/* CAN-IRQ XP0 an/ausschalten */
#define IRQ_DISABLE    __DI()	
#define IRQ_ENABLE     __EI() 


#define SIZE_CODE_C2F  1798   //_TODO  Lnge der CODE_mcan Section

/*Variable fr Copy-Routinen*/
extern volatile  unsigned  int  c2f_counter;   
extern volatile  unsigned  int __far *c2f_src;
extern volatile  unsigned  int __far *c2f_des;

__nosavereg void __far mCAN_flash_main(void);

void mCAN_EvalInitialCmd(void);
void mCAN_Init(void);
void mCAN_DetectAnswer(void);

#endif