/*
Example for using Interrupt-driven UART Functions.

*/
#include "compiler.h"
#include "mb90495.h"
#include "vectors.h"
#include "can.h"
#include "hardware.h"
#include "timer.h"
#include "i2c.h"
#include "i2c_2.h"
#include "eeprom.h"
#include "adi.h"
#include "pwm.h"
#include "uart1.h"
#include "uart0.h"
#include "mcan.h"


u8_t  databuffer[16];
u8_t len;
//************************************************************
static void Eval_CANFrames(void);			//CAN
//************************************************************
#define CYCLETIME		20	// 20ms Cycletime
//***********************************************************************
// CAN-Queues
#define QUEUE_RCV_SIZE	8	// reserve memory for CAN-Queue, count must be 2,4,8,16,...
#define QUEUE_XMT_SIZE	8	// reserve memory for CAN-Queue, count must be 2,4,8,16,...


//**************************************************************
//UART-Queues
#define TX_entries 17		//UART transmit buffer 8 Byte (max. size + 1)		
#define RX_entries 17		//UART receive buffer 8 Byte (max. size + 1)

//*************** Globale Variablen ****************************

CANI_qentrytyp rcv_queue[QUEUE_RCV_SIZE];	
CANI_qentrytyp xmt_queue[QUEUE_XMT_SIZE];	

u8_t Buf_XMTQueue0[TX_entries];
u8_t Buf_RCVQueue0[RX_entries];
u8_t Buf_XMTQueue1[TX_entries];
u8_t Buf_RCVQueue1[RX_entries];
//***********************************************************************
void Timer_2000Hz()
{
	static u8_t n;
	
	n++;
	if(n&1)	// nur jedes 2. mal aufrufen
	{
		LED_1000Hz();
	}
}
//***********************************************************************
static void Eval_CANFrames()
{
	if(CAN_Read()==CAN_ERR_OK)	// if an new CAN-Message was received
	{
		switch(CAN_BUFF_ID)
		{
			// Firmwareupdate via CAN
			//convert x.mhx into x.bin via mot2bin.exe (see ...\Release\ABS) and upload with CAN2Flash.exe to MicroMod  
			case 0x7e7:
/* 
The Library-Funktion  CAN_Read() fills the variables CAN_BUFF_ID, CAN_BUFF_LEN, CAN_BUFF_DATA[8] with the last Queue-entry of the CAN-message.
When using own CAN-LowLevel drivers must befor call the function mCAN_EvalInitialCmd() the variables
CAN_BUFF_ID
CAN_BUFF_LEN
CAN_BUFF_DATA[8]
be filled with the CAN-data.

*/
				// all outputs off
				Set_DOUT(0,0);
				Set_DOUT(1,0);
				Set_DOUT(2,0);
				Set_DOUT(3,0);
				Set_DOUT(4,0);
				Set_DOUT(5,0);
				Set_DOUT(6,0);
				Set_DOUT(7,0);
				
				mCAN_EvalInitialCmd();			
			break;
	//process other CAN-ID 
			case 0x100:				
				UART0_Write((u8_t*)"abcd0",5);	
			break;
			case 0x101:				
				UART1_Write((u8_t*)"abcd1",5);	
			break;
			
			default:
			break;
		} // switch
		
	} // if(CAN_Read()=...
}
//*************************************************************
void main()
{
	InitIrqLevels();
    __set_il(7);		// allow all levels 

	Hardware_Init();
	Timer_Init();
	I2C_Init();
	
	UART0_SetXMTQueue(Buf_XMTQueue0, TX_entries);		//transmit-buffer
	UART0_SetRCVQueue(Buf_RCVQueue0, RX_entries);		//receive-buffer
	UART0_Init(38400,BITLEN_8,NO_PARITY,STOPLEN_1);
	
	UART1_SetXMTQueue(Buf_XMTQueue1, TX_entries);		//transmit-buffer
	UART1_SetRCVQueue(Buf_RCVQueue1, RX_entries);		//receive-buffer
	UART1_Init(38400,BITLEN_8,NO_PARITY,STOPLEN_1);
	
	CAN_SetRCVQueue(rcv_queue, QUEUE_RCV_SIZE);	// Set Receive Queue to 8 entries, 
	CAN_SetXMTQueue(xmt_queue, QUEUE_XMT_SIZE);	// Set CAN Transmit Queue to 8 entries
	CAN_Init(CAN_BAUD_500K);
	CAN_RegisterMsg(0);
	CAN_Online();
	__EI();				// Enable Interrupts

	Timer_Set(0,2);
	for(;;)
	{
		WATCHDOG;
		Eval_CANFrames();
	
		if(Timer(0)==0)
		{
			Timer_Set(0, CYCLETIME);
			len = UART1_Read(databuffer, 16);	// read up to 16 bytes
			if(UART0_GetTXFree()>=len && len!=0)
			{
				UART0_Write(databuffer,len);
				CAN_BUFF_ID=0;
				CAN_BUFF_LEN=1;
				CAN_BUFF_DATA[0]=databuffer[0];
				CAN_Write();

			}
				
			len = UART0_Read(databuffer, 16);
			if(UART1_GetTXFree()>=len && len!=0)
			{
				UART1_Write(databuffer,len);				
				CAN_BUFF_ID=1;
				CAN_BUFF_LEN=1;
				CAN_BUFF_DATA[0]=databuffer[0];
				CAN_Write();
			}
		}

	} //for_ever loop 
}