
#ifndef __I2CH__        /* Schutz gegen mehrfaches #include */
#define __I2CH__

/***********************************************************************
 *      i2c.h
 *      Funktion: Headerdatei fuer das Softwaremodul "i2c.c".
 *
 *      Autor   : Bohlen
 *      Sprache : 
 *
 *      ----------------------------------------------------------------
 *      */

/***********************************************************************
 *	I2C_MasterChipSelect
 *	schreibt das Controlbyte zum Ansprechen eines Chips
 *	auf den I2C-Bus
 *	typeaddr: 4-Bit feste Kennung eines Chip
 *	chipaddr: 3 Bit variable Adresse eines Chip
 *	rw: 0 = Schreiben, 1 = Lesen
 ***********************************************************************/

#define I2C_MasterChipSelect(typeaddr,chipaddr,read) \
	    I2C_MasterWrite( ((typeaddr) << 4) | ((chipaddr) << 1) | (read))

#define I2C_CTL_READ	1
#define I2C_CTL_WRITE	0

// <TITLE I2C_Init>
// Description:
// Initializes the I2C-Interface. This is used by the On-Board EEprom.
// Parameter:
// none
// Result:
// none
u8_t   I2C_Init(void);

// <TITLE I2C_Start>
// Description:
// Generates Start-Sequence for I2C-Bus.
// Parameter:
// none
// Result:
// none
void    I2C_Start(void);

// <TITLE I2C_MasterWrite()>
// Description:
// Writes ony Byte to the I2C-Bus. 
// Parameter:
// input_byte: Byte that is written to the I2C_Bus.
// Result:
// 0: acknowledge-error
//
// 1: write successful 
u8_t   I2C_MasterWrite(u8_t input_byte);

// <TITLE I2C_MasterRead()>
// Description:
// Reads ony Byte from the I2C-Bus. 
// Parameter:
// ack: 1 generate no acknowledge 
//
// 0: generate acknowledge
// Result:
// Data from I2C-Bus.
u8_t   I2C_MasterRead(u8_t ack);

// <TITLE I2C_Stop>
// Description:
// Generates Stop-Sequence for I2C-Bus.
// Parameter:
// none
// Result:
// none
u8_t   I2C_Stop(void);

void I2C_Delay(long count);

/* Functionen */

void  I2C_Page_Read  (u16_t adr,u8_t *dat,u16_t len);
void  I2C_Page_Write (u16_t adr,u8_t *dat,u16_t len);
u8_t I2C_Byte_Read  (u16_t adr);
void  I2C_Byte_Write (u16_t adr,u8_t dat);


#endif
