#ifndef _PWM_H_
#define _PWM_H_

// <TITLE  PWM_Init>
// Description:
// Initializes PWM and Frequency output.
// Parameter:
// none
// Result:
// none
void PWM_Init(void);

void Frequency_Init(void);

void PWM_Init16(u8_t channel, u16_t frequency);

// <TITLE  SetPWM()>
// Description:
// Enables PWM-Output with given frequency and duty cycle. The frequency of Channel 0/1 and 2/3 must be equal.
// Parameter:
// chan: 0..3
//
// ratio: duty cycle 0..255
//
// 0=0%, 255=100%
//
// frequency: 32..100, 4000..10000
// Result:
// none
void SetPWM(u8_t chan, u8_t ratio, unsigned int frequency);

void SetPWM_16(u8_t chan, u16_t ratio, u16_t frequency);

// <TITLE  SetFrequency()>
// Description:
// Enables Frequency-Output with given frequency and 50% duty cycle. The MicroMod does only support two Frequency outputs at the same time. If channel 0 (2) is used channel 1 (3) is disabled. 
// Parameter:
// chan: 0, 2
//
// frequency: 1..10000
// Result:
// none
void SetFrequency(u8_t chan, unsigned int frequency);


// <TITLE  GetFrequencyInit>
// Description:
// Initializes Frequency Measurement.
// Parameter:
// none
// Result:
// none
void GetFrequencyInit(void);

// <TITLE  GetFrequency()>
// Description:
// Reads the current frequency signal. This is intended to measure low frequency signals (0..2500Hz)! Higher frequencies will decrease the overall performance of the module.
// Parameter:
// chan: channel 0..3
// Result:
// frequency
u16_t GetFrequency(u8_t chan);

// <TITLE  GetTimer32>
// Description:
// Returns the number of Milliseconds since Power Up.
// Parameter:
// Result:
// Number of Milliseconds.



unsigned long int GetTimer32(void);


void Frequency_2000Hz(void);
__interrupt void INPUTCAPTURE0(void);
__interrupt void INPUTCAPTURE1(void);
__interrupt void INPUTCAPTURE23(void);
__interrupt void IOTIMER(void);

#endif